﻿<?xml version="1.0" encoding="utf-8"?>
<!-- DWXMLSource="prefs.xml" -->
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>
<xsl:template match="/MediaCoderPrefs">
<ul name="_root">
<xsl:call-template name="ShowBranch">
  <xsl:with-param name="cur" select="."/>
</xsl:call-template>
</ul>
</xsl:template>

<xsl:template name="ShowBranch">
	<xsl:param name="cur"/>
	  <xsl:for-each select="$cur/node">
	  <li style="list-style-type: none;cursor:pointer;">
	  <xsl:attribute name="name"><xsl:value-of select="@key"/></xsl:attribute>
	  <xsl:if test="@type != 'node'">
	  <a>
      <xsl:attribute name="onmouseover">ShowDesc(this)</xsl:attribute>
      <xsl:attribute name="onmouseout">tooltip.hide()</xsl:attribute>      
	  <span><img src="img/node.png"/>&nbsp;<xsl:value-of select="@text"/></span></a>
	  </xsl:if>
	  <xsl:choose>
	  <xsl:when test="@type = 'node'">
	  <a onclick="Toggle(this)">
      <xsl:attribute name="onmouseover">ShowDesc(this)</xsl:attribute>
      <xsl:attribute name="onmouseout">tooltip.hide()</xsl:attribute>      
	  <xsl:if test="last() = 1">
	  <img src="img/minus.png" /><img src="img/folder_open.png" />
	  </xsl:if>
	  <xsl:if test="last() != 1">
	  <img src="img/plus.png" /><img src="img/folder_closed.png" />
	  </xsl:if>
	  <span>&nbsp;<xsl:value-of select="@text"/></span></a>
	  <ul>
  	    <xsl:if test="last() != 1">
			<xsl:attribute name="style">display:none</xsl:attribute>
		</xsl:if>
		<xsl:call-template name="ShowBranch">
		  <xsl:with-param name="cur" select="."/>
		</xsl:call-template>
	  </ul>
	  </xsl:when>
	  <xsl:otherwise>
  	   <span>&nbsp;
	   	<xsl:call-template name="ShowValue">
		  <xsl:with-param name="cur" select="."/>
		</xsl:call-template>
		</span>
	  </xsl:otherwise>
	  </xsl:choose>
	  </li>
	  </xsl:for-each>

</xsl:template>

<xsl:template name="ShowValue">
	<xsl:param name="cur"/>
	<xsl:choose>
	<xsl:when test="$cur/@type='bool'">
	<input onclick="SetValue(this, checked)" name="rb" type="checkbox">
	<xsl:if test="$cur/value='true'"><xsl:attribute name="checked"/></xsl:if>
	</input>
	</xsl:when>

	<xsl:when test="$cur/@type='enum'">
    <xsl:if test="count(enum) &gt;= 5">
	<select name="" onchange="SetValue(this, value)">
	<xsl:for-each select="$cur/enum">
	  <option>
      <xsl:attribute name="value"><xsl:value-of select="." /></xsl:attribute>
	  <xsl:if test=".=../value"><xsl:attribute name="selected"/> </xsl:if>
	  <xsl:value-of select="." /></option>
	</xsl:for-each>
	</select>
    <input type="button" value="Revert" onclick="RevertPrefValue(previousSibling)"/>
    </xsl:if>
    <xsl:if test="count(enum) &lt; 5">
	  <xsl:for-each select="enum">
      <label>
        <input type="radio">
          <xsl:attribute name="name"><xsl:value-of select="../../../@key"/><xsl:value-of select="../../@key"/><xsl:value-of select="../@key"/></xsl:attribute>
		  <xsl:attribute name="onclick">SetValue(this, '<xsl:value-of select="."/>')</xsl:attribute> 
          <xsl:if test=".=../value">
            <xsl:attribute name="checked">true</xsl:attribute>
          </xsl:if>
        </input>
          <xsl:value-of select="."/>
          </label>
      </xsl:for-each>
	</xsl:if>
	</xsl:when>

	<xsl:when test="$cur/@type='int' or $cur/@type='float'">
	<input name="text" type='text' onchange='SetValue(this, value)' size='6'>
	  <xsl:choose>
	  <xsl:when test="$cur/value">
	  <xsl:attribute name="value"><xsl:value-of select="$cur/value"/></xsl:attribute>
	  </xsl:when>
	  <xsl:otherwise>
	  <xsl:attribute name="value">0</xsl:attribute>
	  </xsl:otherwise>
	  </xsl:choose>
	</input>
    <input type="button" value="Save" onclick="SetValue(previousSibling, previousSibling.value)"/>
    <input type="button" value="Revert" onclick="RevertPrefValue(previousSibling.previousSibling)"/>
	</xsl:when>

	<xsl:otherwise>
	<input onChange='SetValue(this, value)' type='text' size='30'>
	<xsl:attribute name="value"><xsl:value-of select="$cur/value"/></xsl:attribute>
	</input>
    <input type="button" value="Save" onclick="SetValue(previousSibling, previousSibling.value)"/>
    <input type="button" value="Revert" onclick="RevertPrefValue(previousSibling.previousSibling)"/>
	</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>

</xsl:stylesheet>